/*

Modelspoor stack modules
www.stackmodules.nl
Ed den Ouden 2020-2024



Functie sketch:           deze sketch test de leds van het SB 'test en debug' op de basis boards (DCC-ex, DCC-decoder, Loconet client, locoNet centrale)
Board:                    Nano V3 328p
Instellen door gebruiker: pinmapping bij 'Door de gebruiker in te stellen variabelen' */



// Door de gebruiker in te stellen variabelen

int aantalKanalen = 16;     // Aantal kanalen om te testen
int knipperSnelheid = 250;  // Milliseconden, delay



// Pinmapping, selecteer de juiste pinmap voor het basis board
// Kanalen           1  2  3  4  5  6  7  8  9   10  11  12  13  14  15  16
// ------------------------------------------------------------------------
//int usedPins[] = { 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 14, 15, 16, 17, 18, 19 };     // Voor basis board DCC-EX, channel 1-16 op stack board
int usedPins[] = { 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 };       // Voor basis board DCC-EX I2C, channel 1-16 op stack board
//int usedPins[] = { 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19 };    // Voor basis board DCC-decoder, channel 1-16 op stack board
//int usedPins[] = { 2, 3, 4, 5, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 };   // Voor basis board LocoClient, channel 1-16 op stack board
//int usedPins[] = { 2, 3, 4, 5, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19 };   // Voor basis board LocoBuffer, channel 1-16 op stack board

// Einde door de gebruiker in te stellen variabelen



void setup() {

  Serial.begin(115200);
  Serial.println("Modelspoor stack modules - www.stackmodules.nl - Ed den Ouden 2024");
  Serial.println("");
  Serial.println("Deze sketch test via de LED's 1-16 van het SB 'test en debug' het basis board (DCC-EX, DCC-EX I2C, DCC-decoder, LocoClient, LocoBuffer)");
  Serial.println("");
  Serial.println("Voor basis boards DCC-decoder, DCC-EX, DCC-EX I2C & LocoClient: de stack module werkt correct indien LED's 1-16 één voor één aan/uit gaan...");
  Serial.println("");
  Serial.println("Voor Basis board LocoBuffer: de stack module werkt correct indien LED's 1-2 branden en de LED's 3-16 één voor één aan/uit gaan...");
  Serial.println("");

  for (int i = 0; i < aantalKanalen; i++) {
    pinMode(usedPins[i], OUTPUT);
  }
}



void loop() {

  for (int i = 0; i < aantalKanalen; i++) {
    digitalWrite(usedPins[i], HIGH);
    delay(knipperSnelheid);
    digitalWrite(usedPins[i], LOW);
    delay(knipperSnelheid);
    Serial.println(i + 1);
  }
  Serial.println("");
}
